SET TERM ^ ;

EXECUTE BLOCK
AS 
  DECLARE VARIABLE PRENOTATO_SERIALE VARCHAR(40);
  DECLARE VARIABLE PRENOTATO_ID_DOC INTEGER;
  DECLARE VARIABLE PRENOTATO_ID_PK INTEGER; 
  DECLARE VARIABLE EVASO_SERIALE VARCHAR(40);
  DECLARE VARIABLE EVASO_ID_DOC INTEGER;
  DECLARE VARIABLE EVASO_ID_PK INTEGER; 
BEGIN
  FOR
    SELECT
      A.CODICESERIALEPRENOTATO,
      B.ID AS PRENOTATO_ID_DOC,
      A.CODICESERIALEEVASO,
      C.ID AS EVASO_ID
      
    FROM
      LOGSWAP A
      
      INNER JOIN DDT B ON
      A.PLINEADDT=B.LINEA
      AND
      A.PDATADDT=B.DATADOCUMENTO
      AND
      A.PNUMERODDT=B.NDOCUMENTO
      
      LEFT JOIN DDT C ON
      A.ELINEADDT=C.LINEA
      AND
      A.EDATADDT=C.DATADOCUMENTO
      AND
      A.ENUMERODDT=C.NDOCUMENTO
    
    ORDER BY
      A.ID
    
    INTO
      :PRENOTATO_SERIALE,
      :PRENOTATO_ID_DOC,
      :EVASO_SERIALE,
      :EVASO_ID_DOC
  DO
  BEGIN
    --Carico info PK del seriale prenotato       
    SELECT
      B.ID
      
    FROM
      PKLISTCOLLI A
      
      INNER JOIN PKLISTARTICOLI B ON
      A.ID=B.IDCOLLO
    
    WHERE
      A.IDDOC=:PRENOTATO_ID_DOC
      AND
      B.SERIALE=:PRENOTATO_SERIALE
    
    INTO
      :PRENOTATO_ID_PK;      
    
    --Carico info PK del seriale evaso
    EVASO_ID_PK=NULL;
    
    IF (EVASO_ID_DOC IS NOT NULL) THEN
    BEGIN    
      SELECT
        B.ID
      
      FROM
        PKLISTCOLLI A
      
        INNER JOIN PKLISTARTICOLI B ON
        A.ID=B.IDCOLLO
    
      WHERE
        A.IDDOC=:EVASO_ID_DOC
        AND
        B.SERIALE=:EVASO_SERIALE
    
      INTO
        :EVASO_ID_PK;  
      
    END
    
    --Swap su prenotato
    IF (PRENOTATO_ID_PK IS NOT NULL) THEN
    BEGIN
      UPDATE PKLISTARTICOLI SET
        SERIALE=:EVASO_SERIALE
      
      WHERE
        ID=:PRENOTATO_ID_PK;
      
    END 
    
    --Swap su evaso
    IF (EVASO_ID_PK IS NOT NULL) THEN
    BEGIN
      UPDATE PKLISTARTICOLI SET
        SERIALE=:PRENOTATO_SERIALE
      
      WHERE
        ID=:EVASO_ID_PK;
      
    END     
  END     
END^

SET TERM ; ^
